﻿namespace MSI.VideoSamples.VideoPlayback.ViewModels
{
    using MSI.VideoSamples.VideoPlayback.Helpers;
    using MSI.VMS;
    using System.Diagnostics;
    using System.Windows.Input;

    internal partial class MainWindowViewModel : BaseViewModel
    {

        private const string OnlineMapsUrl = "https://www.google.com/maps/place/";

        /// <summary>
        /// Gets or sets go to geolocation command.
        /// </summary>
        public ICommand GoToGeolocationCommand => new DelegateCommand((selectedDevice) =>
        {
            if (selectedDevice is Device device)
            {
                Process.Start($"{OnlineMapsUrl}{device.Geolocation.Latitude:0.0000000}+{device.Geolocation.Longitude:0.0000000}");
            }
        });
    }
}
