﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents RTSP video stream initialization request.
    /// </summary>
    public class RtspRequest
    {
        /// <summary>
        /// Gets or sets the camera ID. This is edge device camera ID and it's different than the one used in request for camera data_sources. Use id value as returned in data_sources request.
        /// </summary>
        [JsonProperty("cameraId")]
        public string CameraId { get; set; }

        /// <summary>
        /// Gets or sets the media type. This has to be <c>video</c> for RTSP stream.
        /// </summary>
        [JsonProperty("media")]
        public string Media { get; set; }

        /// <summary>
        /// Gets or sets video quality, can be either <c>high</c> or <c>low</c>.
        /// </summary>
        [JsonProperty("quality")]
        public string Quality { get; set; }

        /// <summary>
        /// Gets or sets the video start time stamp. Should be <c>live</c> for live video or ISO 8601 time stamp for recorded video.
        /// </summary>
        [JsonProperty("t")]
        public string T { get; set; }

        /// <summary>
        /// Gets or sets the value indicating if it should search for next available video clip after the provided time stamp.
        /// </summary>
        [JsonProperty("search")]
        public bool Search { get; set; }
    }
}
