﻿namespace MSI.VideoSamples.VideoPlayback.Models.System
{
    using global::System;
    using global::System.IO;
    using global::System.Net.Http;
    using global::System.Threading.Tasks;
    using MSI.VideoSamples.VideoPlayback.Extensions;
    using MSI.VMS;
    using Newtonsoft.Json;

    /// <summary>
    /// Class implementing System API model.
    /// </summary>
    internal class VmsSystemModel
    {
        private const string SystemApi = "/system";
        private const string Accept = "Accept";
        private const int MinApiVersion = 1;
        private const int MaxApiVersion = 1;

        private readonly string acceptHeaderValue = $"application/json; version={MinApiVersion}-{MaxApiVersion}";
        private readonly HttpClient httpClient;

        /// <summary>
        /// Initializes instance of <see cref="VmsSystemModel"/> class.
        /// </summary>
        /// <param name="httpClient">
        /// <see cref="HttpClient"./> instance.
        /// </param>
        internal VmsSystemModel(HttpClient httpClient)
        {
            this.httpClient = httpClient;
        }

        /// <summary>
        /// Asynchronously gets information about VMS System.
        /// </summary>
        /// <param name="baseApiUri">Base API URI.</param>
        /// <returns>
        /// Task returning instance of <see cref="VmsSystem"./>
        /// </returns>
        internal async Task<VmsSystem> GetSystemInforamtionAsync(Uri baseAPiUri)
        {
            Uri requestUri = new Uri(baseAPiUri, SystemApi);

            using (HttpRequestMessage requestMessage = new HttpRequestMessage(HttpMethod.Get, requestUri))
            {
                requestMessage.Headers.Add(Accept, acceptHeaderValue);

                using (HttpResponseMessage httpGetSystemInformationResponse = await this.httpClient.SendAsync(requestMessage))
                {
                    httpGetSystemInformationResponse.EnsureSuccessStatusCodeAndGetInnerMessage();
                    using (Stream responseStream = await httpGetSystemInformationResponse?.Content.ReadAsStreamAsync())
                    {
                        if (responseStream != null)
                        {
                            using (var streamReader = new StreamReader(responseStream))
                            {
                                var responseString = streamReader.ReadToEnd();
                                return JsonConvert.DeserializeObject<VMS.VmsSystem>(responseString);
                            }
                        }
                        else
                        {
                            return null;
                        }
                    }
                }
            }
        }
    }
}
