﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents links available under <see cref="VmsSystem"/>.
    /// </summary>
    public class VmsSystemLinks
    {
        /// <summary>
        /// Gets or sets the URL of this resource.
        /// </summary>
        [JsonProperty("rel/self")]
        public string RelSelf { get; set; }

        /// <summary>
        /// Gets or sets the URL for authentication.
        /// </summary>
        [JsonProperty("rel/login")]
        public string RelLogin { get; set; }

        /// <summary>
        /// Gets or sets the URL of the collection of all Devices on this system.
        /// </summary>
        [JsonProperty("rel/devices")]
        public string RelDevices { get; set; }
    }
}
