﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents the available resources in a VMS system.
    /// </summary>
    public class VmsSystem
    {
        /// <summary>
        /// Gets or sets unique System identifier.
        /// </summary>
        [JsonProperty("id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets friendly name of the entire system.
        /// </summary>
        [JsonProperty("name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets links to available resources in the system.
        /// </summary>
        [JsonProperty("_links")]
        public VmsSystemLinks _Links { get; set; }

        /// <summary>
        /// Gets or sets unique System identifier.
        /// </summary>
        [JsonProperty("_system_id")]
        public string _SystemId { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string _Type { get; set; }
    }
}
