﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents video snapshot request.
    /// </summary>
    public class SnapshotRequest
    {
        /// <summary>
        /// Gets or sets the snapshot time stamp. Should be <c>live</c> for live video snapshot or ISO 8601 time stamp for recorded video snapshot.
        /// </summary>
        [JsonProperty("time")]
        public string Time { get; set; }

        /// <summary>
        /// Gets or sets the earliest start time when searching backward for a image provided in ISO 8601 UTC.
        /// </summary>
        [JsonProperty("time_min")]
        public string TimeMin { get; set; }

        /// <summary>
        /// Gets or sets the latest start time when searching forward for a image provided in ISO 8601 UTC.
        /// </summary>
        [JsonProperty("time_max")]
        public string TimeMax { get; set; }

        /// <summary>
        /// Gets or sets the search mode,
        /// can be one of:
        ///     <c>search_closest</c> - closest match
        ///     <c>search_before</c> - search before the date
        ///     <c>search_after</c> - search after the date
        ///     <c>search_exact</c> - search exact date
        /// </summary>
        [JsonProperty("search_type")]
        public string SearchType { get; set; }

        /// <summary>
        /// Gets or sets the snapshot width.
        /// </summary>
        [JsonProperty("width")]
        public int? Width { get; set; }

        /// <summary>
        /// Gets or sets the snapshot width.
        /// </summary>
        [JsonProperty("height")]
        public int? Height { get; set; }

        /// <summary>
        /// Gets or sets snapshot quality, can be either <c>high</c> or <c>low</c>.
        /// </summary>
        [JsonProperty("quality")]
        public string Quality { get; set; }
    }
}
