﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents video snapshot meta data.
    /// </summary>
    public class SnapshotMetadata
    {
        /// <summary>
        /// Gets or sets the snapshot time stamp in ISO 8601 format.
        /// </summary>
        [JsonProperty("media_time")]
        public string MediaTime { get; set; }

        /// <summary>
        /// Gets or sets the actual snapshot width.
        /// </summary>
        [JsonProperty("media_width")]
        public int? MediaWidth { get; set; }

        /// <summary>
        /// Gets or sets the actual snapshot height.
        /// </summary>
        [JsonProperty("media_height")]
        public int? MediaHeight { get; set; }
    }
}
