﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents a predefined sequence of PTZ presets that a PTZ device can continuously navigate through when triggered.
    /// </summary>
    public class PtzTour
    {
        /// <summary>
        /// Gets or sets the unique numerical identifier of this PTZ Tour.
        /// </summary>
        [JsonProperty("index")]
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        [JsonProperty("name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the links available for this PTZ Tour.
        /// </summary>
        [JsonProperty("_links")]
        public PtzTourLinks _Links { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string _Type { get; set; }
    }
}
