﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents a predefined point that a PTZ device can PTZ to when triggered.
    /// </summary>
    public class PtzPreset
    {
        /// <summary>
        /// Gets or sets the unique numerical identifier of this Ptz Preset.
        /// </summary>
        [JsonProperty("index")]
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        [JsonProperty("name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the links available for this PTZ Preset.
        /// </summary>
        [JsonProperty("_links")]
        public PtzPresetLinks _Links { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string _Type { get; set; }
    }
}
