﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents links available under <see cref="PtzController"/>.
    /// </summary>
    public class PtzControllerLinks
    {
        /// <summary>
        /// Gets or sets the URL of this resource.
        /// </summary>
        [JsonProperty("rel/self")]
        public string RelSelf { get; set; }

        /// <summary>
        /// Provides the URL for stopping current camera tour or pattern.
        /// </summary>
        [JsonProperty("rel/halt")]
        public string RelHalt { get; set; }

        /// <summary>
        /// Provides the URL for moving camera to its home position.
        /// </summary>
        [JsonProperty("rel/home")]
        public string RelHome { get; set; }

        /// <summary>
        /// Provides the URL for list of available presets.
        /// </summary>
        [JsonProperty("rel/presets")]
        public string RelPresets { get; set; }

        /// <summary>
        /// Provides the URL for list of available tours.
        /// </summary>
        [JsonProperty("rel/tours")]
        public string RelTours { get; set; }
    }
}
