﻿using MSI.VMS;
using System.Collections.ObjectModel;
using System.Windows;

namespace MSI.VideoSamples.VideoPlayback.Models.Events
{
    /// <summary>
    /// Provides access to global collection of events.
    /// </summary>
    internal static class GlobalEventsCollection
    {
        private static ObservableCollection<Event> observableCollection;

        /// <summary>
        /// Adds new event to global collection.
        /// </summary>
        /// <param name="newEvent">
        /// New <see cref="Event"/> to be added to collection.
        /// </param>
        public static void Add(Event newEvent)
        {
            Application.Current.Dispatcher.Invoke(() =>
                 {
                     observableCollection?.Add(newEvent);
                 });
        }

        /// <summary>
        /// Creates or gets existing collection.
        /// </summary>
        /// <returns>
        /// The reference to global <see cref="ObservableCollection{T}"/> of <see cref="Event"/>.
        /// </returns>
        public static ObservableCollection<Event> CreateOrGetEventsCollection()
        {
            if (observableCollection == null)
            {
                observableCollection = new ObservableCollection<Event>();
            }
            return observableCollection;
        }
    }
}
