﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents ACS event payload.
    /// </summary>
    internal class EventPayload
    {
        /// <summary>
        ///	The message envelope version number.
        /// </summary>
        [JsonProperty("version")]
        public string Version { get; set; }

        /// <summary>
        ///	The user ID based on the user name and password created to configure the webhook central station.
        /// </summary>
        [JsonProperty("agentUserId")]
        public string AgentUserId { get; set; }

        /// <summary>
        ///	The tenant ID based on the user name and password created to configure the webhook central station.
        /// </summary>
        [JsonProperty("agentUserTenantId")]
        public string AgentUserTenantId { get; set; }

        /// <summary>
        ///	The Avigilon Blue alarm ID.
        /// </summary>
        [JsonProperty("alarmId")]
        public string AlarmId { get; set; }

        /// <summary>
        ///	The tenant ID of the organization in which the alarm occurred.
        /// </summary>
        [JsonProperty("alarmTenantId")]
        public string AlarmTenantId { get; set; }

        /// <summary>
        ///	The type of event. Values can be “health” or “security”. Health events refer to device events. Security events refer to video analytics events.
        /// </summary>
        [JsonProperty("eventClass")]
        public string EventClass { get; set; }

        /// <summary>
        ///	The name of the event.This will be the same as the name of the analytic rule that triggered the event.
        /// </summary>
        [JsonProperty("eventName")]
        public string EventName { get; set; }

        /// <summary>
        ///	The analytic rule activity that signaled the event.
        /// </summary>
        [JsonProperty("eventType")]
        public string EventType { get; set; }

        /// <summary>
        ///	The name of the analytic rule that triggered the event.
        ///	This is typically the same value as the eventName.
        /// </summary>
        [JsonProperty("eventRuleName")]
        public string EventRuleName { get; set; }

        /// <summary>
        ///	The time the event started in ISO 8601 format in UTC.
        /// </summary>
        [JsonProperty("eventStartTime")]
        public string EventStartTime { get; set; }

        /// <summary>
        ///	The time the event ended in ISO 8601 format in UTC.
        ///	If the event is on-going, the value will be “null”.
        /// </summary>
        [JsonProperty("eventEndTime")]
        public string EventEndTime { get; set; }

        /// <summary>
        ///	The tenant ID of the organization in which the event occurred.
        /// </summary>
        [JsonProperty("entityTenantId")]
        public string EntityTenantId { get; set; }

        /// <summary>
        ///	The site ID of the server associated with the event.
        /// </summary>
        [JsonProperty("locationId")]
        public string LocationId { get; set; }

        /// <summary>
        ///	The name of the site associated with the event.
        /// </summary>
        [JsonProperty("locationName")]
        public string LocationName { get; set; }

        /// <summary>
        ///	The ID of the server associated with the event.
        /// </summary>
        [JsonProperty("serverId")]
        public string ServerId { get; set; }

        /// <summary>
        ///	The name of the server associated with the event.
        /// </summary>
        [JsonProperty("serverName")]
        public string ServerName { get; set; }

        /// <summary>
        ///	The ID of the camera associated with the event.
        /// </summary>
        [JsonProperty("cameraId")]
        public string CameraId { get; set; }

        /// <summary>
        ///	The name of the camera associated with the event.
        /// </summary>
        [JsonProperty("cameraName")]
        public string CameraName { get; set; }

        /// <summary>
        ///	The ID of a camera from a connected ACC site.
        /// </summary>
        [JsonProperty("cameraRemoteId")]
        public string CameraRemoteId { get; set; }

        /// <summary>
        ///	The ID of the event video clip.
        /// </summary>
        [JsonProperty("clipId ")]
        public string ClipId { get; set; }

        /// <summary>
        ///	The URI of the event video clip.
        /// </summary>
        [JsonProperty("clipUri")]
        public string ClipUri { get; set; }

        /// <summary>
        ///	The Gateway servicing the associated Event Entities
        ///	</summary>
        [JsonProperty("gatewayId")]
        public string GatewayId { get; set; }
    }
}
