﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents ACS Event.
    /// </summary>
    internal class Event
    {
        /// <summary>
        /// The payload type.For central station webhooks, the value will always be “BlueEvent”.
        /// Informs the client how to decode the Payload which can then be specified as a polymorphic Object.
        /// </summary>
        [JsonProperty("payloadType")]
        public string PayloadType { get; set; }

        /// <summary>
        /// The version number of the envelope.
        /// </summary>
        [JsonProperty("version")]
        public string Version { get; set; }

        /// <summary>
        /// The message ID.
        /// </summary>
        [JsonProperty("messageId")]
        public string MessageId { get; set; }

        /// <summary>
        /// The time the message was sent in ISO 8601 format in UTC.
        /// </summary>
        [JsonProperty("transmitTime")]
        public string TransmitTime { get; set; }

        /// <summary>
        /// A correlation ID that can be used to track the message in the ACS service.
        /// </summary>
        [JsonProperty("logCorrelationId")]
        public string LogCorrelationId { get; set; }

        /// <summary>
        /// If HTTPS is used, the value will be the Shared Secret Phrase.
        /// If HTTP is used, the value will be “null”.
        /// </summary>
        [JsonProperty("authenticationToken")]
        public string AuthenticationToken { get; set; }

        /// <summary>
        /// The message payload. See <see cref="EventPayload"> for details.
        /// </summary>
        [JsonProperty("payload")]
        public EventPayload Payload { get; set; }
    }
}
