﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents geolocation available under <see cref="Device"/>.
    /// </summary>
    public class DeviceGeolocation
    {
        /// <summary>
        /// Gets or sets the Latitude from geolocation for this Device.
        /// </summary>
        [JsonProperty("latitude")]
        public double Latitude { get; set; }

        /// <summary>
        /// Gets or sets the Longitude from geolocation for this Device.
        /// </summary>
        [JsonProperty("longitude")]
        public double Longitude { get; set; }

        /// <summary>
        /// Gets or sets the Altitude from geolocation for this Device.
        /// </summary>
        [JsonProperty("altitude")]
        public double Altitude { get; set; }
    }
}