﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents a particular physical device in the system (e.g.: a camera).
    /// </summary>
    public class Device
    {
        /// <summary>
        /// Gets or sets the name of the Device site.
        /// </summary>
        [JsonProperty("site_name")]
        public string SiteName { get; set; }

        /// <summary>
        /// Gets or sets the name of the Device system tenant.
        /// </summary>
        [JsonProperty("tenant_name")]
        public string TenantName { get; set; }

        /// <summary>
        /// Gets or sets the unique Device identifier.
        /// </summary>
        [JsonProperty("id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the user specified location of the Device. E.g. Third floor hallway camera.
        /// </summary>
        [JsonProperty("location_description")]
        public string LocationDescription { get; set; }

        /// <summary>
        /// Gets or sets the user specified geolocation of the Device. E.g. 50.048358, 19.8661826.
        /// </summary>
        [JsonProperty("geolocation")]
        public DeviceGeolocation Geolocation { get; set; }

        /// <summary>
        /// Gets or sets the MAC address.
        /// </summary>
        [JsonProperty("mac_address")]
        public string MacAddress { get; set; }

        /// <summary>
        /// Gets or sets the product model name.
        /// </summary>
        [JsonProperty("model")]
        public string Model { get; set; }

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        [JsonProperty("name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the serial number.
        /// </summary>
        [JsonProperty("serial")]
        public string Serial { get; set; }

        /// <summary>
        /// Gets or sets the current operational state.
        /// </summary>
        [JsonProperty("state")]
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the particular type of the Device.
        /// </summary>
        [JsonProperty("type")]
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the links available for this Device.
        /// </summary>
        [JsonProperty("_links")]
        public DeviceLinks _Links { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string _Type { get; set; }
    }
}
