﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents links available under <see cref="DataSource"/>.
    /// </summary>
    public class DataSourceLinks
    {
        /// <summary>
        /// Gets or sets the URL used to initialize RTSP session.
        /// </summary>
        [JsonProperty("rel/rtsp")]
        public string Rtsp { get; set; }

        /// <summary>
        /// Gets or sets the URL of Pan-Tilt-Zoom camera device controller.
        /// </summary>
        [JsonProperty("rel/ptz_controller")]
        public string PtzController { get; set; }

        /// <summary>
        /// Gets or sets the URL used to get video snapshot.
        /// </summary>
        [JsonProperty("rel/Snapshot")]
        public string Snapshot { get; set; }
    }
}
