﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents a data producer in the system (e.g. an audio, video, or meta-data output stream) hosted by a system Device (e.g. a camera or microphone).
    /// </summary>
    public class DataSource
    {
        /// <summary>
        /// Gets or sets the unique DataSource identifier.
        /// </summary>
        [JsonProperty("id")]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets user specified location of this DataSource. E.g. Third floor hallway camera.
        /// </summary>
        [JsonProperty("location_description")]
        public string LocationDescription { get; set; }

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        [JsonProperty("name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the current operational state.
        /// </summary>
        [JsonProperty("state")]
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the particular type of this DataSource.
        /// </summary>
        [JsonProperty("type")]
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the links available for this source.
        /// </summary>
        [JsonProperty("_links")]
        public DataSourceLinks _Links { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string _Type { get; set; }
    }
}
