﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents meta-data for a Resource collection. A CollectionHeader will be present for any collection that provides Paging. If not present, the entire collection shall be returned.
    /// </summary>
    public class CollectionHeader
    {
        /// <summary>
        /// Gets or sets the index of the first item returned in this page of the collection.
        /// </summary>
        [JsonProperty("start_index")]
        public int StartIndex { get; set; }

        /// <summary>
        /// Gets or sets the total number of items in the collection, across all pages.
        /// </summary>
        [JsonProperty("total_items")]
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets collection of related links.
        /// </summary>
        [JsonProperty("_links")]
        public CollectionHeaderLinks Links { get; set; }

        /// <summary>
        /// Gets or sets the resource type of this representation.
        /// </summary>
        [JsonProperty("_type")]
        public string Type { get; set; }
    }
}
