﻿namespace MSI.VMS
{
    using Newtonsoft.Json;

    /// <summary>
    /// Represents VMS user.
    /// </summary>
    public class UserInformation
    {
        /// <summary>
        /// Gets or sets user's First Name.
        /// </summary>
        [JsonProperty("FirstName")]
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets user's Last Name.
        /// </summary>
        [JsonProperty("LastName")]
        public string LastName { get; set; }

        /// <summary>
        /// Gets or sets user's email address/identifier.
        /// </summary>
        [JsonProperty("EmailAddress")]
        public string EmailAddress { get; set; }

        /// <summary>
        /// Gets or sets the user type e.g. Agent.
        /// </summary>
        [JsonProperty("UserType")]
        public string UserType { get; set; }

        /// <summary>
        /// Gets or sets user's Organization ID.
        /// </summary>
        [JsonProperty("TenantId")]
        public string TenantId { get; set; }

        /// <summary>
        /// Gets or sets user's Organization Name.
        /// </summary>
        [JsonProperty("TenantName")]
        public string TenantName { get; set; }

        /// <summary>
        /// Gets or sets user's organization Type, e.g. Provider.
        /// </summary>
        [JsonProperty("TenantType")]
        public string TenantType { get; set; }
    }
}
