﻿using MSI.VideoSamples.VideoPlayback.Extensions;
using MSI.VMS;
using Newtonsoft.Json;
using System;
using System.IO;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace MSI.VideoSamples.VideoPlayback.Models.Authentication
{
    /// <summary>
    /// Represents Video API model.
    /// </summary>
    internal class AuthenticationModel : IDisposable
    {
        private const string contentTypeJson = "application/json";

        /// <summary>
        /// Holds a read-only reference to <see cref="HttpClient" instance./>
        /// </summary>
        private readonly HttpClient httpClient;

        /// <summary>
        /// Indicates if this instance is disposed.
        /// </summary>
        private bool disposedValue;

        /// <summary>
        /// Initializes instance of <see cref="AuthenticationModel"/> class.
        /// </summary>
        /// <param name="httpClient">
        /// <see cref="HttpClient"./> instance.
        /// </param>
        internal AuthenticationModel(HttpClient httpClient)
        {
            this.httpClient = httpClient;
        }

        /// <summary>
        /// Asynchronously posts user credentials to the Login endpoint.
        /// </summary>
        /// <param name="baseApiUri">Base API URI.</param>
        /// <param name="userCredentials">Instance of <see cref="UserCredentials"/>.</param>
        /// <param name="systemInformation">Instance of <see cref="VmsSystem"/>.</param>
        /// <returns>Task returning <see cref="UserInformation"></returns>
        internal async Task<UserInformation> PostLoginAsync(Uri baseApiUri, UserCredentials userCredentials, VmsSystem systemInformation)
        {
            string json = await Task.Run(() => JsonConvert.SerializeObject(userCredentials));
            Uri requestUri = new Uri(baseApiUri, systemInformation._Links.RelLogin);

            using (HttpContent httpContent = new StringContent(json, Encoding.UTF8, contentTypeJson))
            using (HttpResponseMessage httpGetSystemInformationResponse = await this.httpClient.PostAsync(requestUri, httpContent))
            {
                httpGetSystemInformationResponse.EnsureSuccessStatusCodeAndGetInnerMessage();
                using (Stream responseStream = await httpGetSystemInformationResponse?.Content.ReadAsStreamAsync())
                {
                    if (responseStream != null)
                    {
                        using (var streamReader = new StreamReader(responseStream))
                        {
                            var responseString = streamReader.ReadToEnd();
                            return JsonConvert.DeserializeObject<VMS.UserInformation>(responseString);
                        }
                    }
                    else
                    {
                        return null;
                    }
                }
            }
        }

        /// <inheritdoc/>
        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    //
                }

                disposedValue = true;
            }
        }

        /// <inheritdoc/>
        public void Dispose()
        {
            // Do not change this code. Put cleanup code in 'Dispose(bool disposing)' method
            Dispose(disposing: true);
            GC.SuppressFinalize(this);
        }
    }
}
