﻿namespace MSI.VideoSamples.VideoPlayback.Helpers
{
    using Microsoft.Win32;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Reflection;

    public static class RegistryHelper
    {
        /// <summary>
        /// Registry key to store this application data.
        /// </summary>
        private const string AppRegistryKey = @"SOFTWARE\Avigilon\Cloud Services API\SampleApplications";

        /// <summary>
        /// Gets application configuration from the registry
        /// </summary>
        /// <returns>Instance of <see cref="ApplicationConfiguration"/>.</returns>
        public static ApplicationConfiguration GetApplicationConfig()
        {
            RegistryKey registryKey = Registry.CurrentUser.OpenSubKey(AppRegistryKey);
            ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();

            if (registryKey != null)
            {
                Type applicationConfigurationType = applicationConfiguration.GetType();
                PropertyInfo[] applicationConfigurationProperties = applicationConfigurationType.GetProperties();
                IEnumerable<string> propertyNamesFound = registryKey.GetValueNames().Intersect(applicationConfigurationProperties.Select(property => property.Name));
                foreach (string propertyName in propertyNamesFound)
                {
                    PropertyInfo propertyInfo = applicationConfigurationType.GetProperty(propertyName);
                    propertyInfo.SetValue(applicationConfiguration, registryKey.GetValue(propertyName));
                }
            }

            return applicationConfiguration;
        }

        /// <summary>
        /// Saves application configuration to the registry.
        /// </summary>
        /// <param name="applicationConfiguration">Instance of <see cref="ApplicationConfiguration"/> to be saved.</param>
        public static void SaveApplicationConfigToRegistry(ApplicationConfiguration applicationConfiguration)
        {
            RegistryKey registryKey = Registry.CurrentUser.CreateSubKey(AppRegistryKey, true);

            if (registryKey != null)
            {
                Type applicationConfigurationType = applicationConfiguration.GetType();
                PropertyInfo[] applicationConfigurationProperties = applicationConfigurationType.GetProperties();
                foreach (PropertyInfo propertyInfo in applicationConfigurationProperties)
                {
                    registryKey.SetValue(propertyInfo.Name, propertyInfo.GetValue(applicationConfiguration));
                }
            }
        }
    }
}
