﻿namespace MSI.VideoSamples.VideoPlayback.Helpers
{
    /// <summary>
    /// Represents application configuration.
    /// </summary>
    public class ApplicationConfiguration
    {
        /// <summary>
        /// User ID.
        /// </summary>
        public string UserId
        {
            get;
            set;
        }

        /// <summary>
        /// User password.
        /// </summary>
        public string Password
        {
            get;
            set;
        }

        /// <summary>
        /// Subscription key.
        /// </summary>
        public string SubscriptionKey
        {
            get;
            set;
        }

        /// <summary>
        /// API base URL.
        /// </summary>
        public string ApiBaseUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Gets application configuration from the registry.
        /// </summary>
        /// <returns>Instance of <see cref="ApplicationConfiguration"/>.</returns>
        public static ApplicationConfiguration GetFromRegistry()
        {
            return RegistryHelper.GetApplicationConfig();
        }

        /// <summary>
        /// Saves this application configuration to the registry.
        /// </summary>
        public void SaveToRegistry()
        {
            RegistryHelper.SaveApplicationConfigToRegistry(this);
        }
    }
}
