﻿namespace MSI.VideoSamples.VideoPlayback.Extensions
{
    using Newtonsoft.Json.Linq;
    using System;
    using System.Net.Http;

    /// <summary>
    /// Extends <see cref="HttpResponseMessage"/ class.>
    /// </summary>
    public static class HttpResponseMessageExtensions
    {
        /// <summary>
        /// Ensures that a success status code is returned from a HTTP request.
        /// If there is no success status code returned then it throws an exception.
        /// If response contains JSON with <c>Message</c> property then that property value is concatenated to the exception message.
        /// </summary>
        /// <param name="httpResponseMessage">The instance of <see cref="HttpResponseMessage"/>.</param>
        public static void EnsureSuccessStatusCodeAndGetInnerMessage(this HttpResponseMessage httpResponseMessage)
        {
            Predicate<object> HasMessageProperty = jsonObject => ((JObject)jsonObject).Property("Message") != null;
            Predicate<object> HasLowerCaseMessageProperty = jsonObject => ((JObject)jsonObject).Property("message") != null;

            if (!httpResponseMessage.IsSuccessStatusCode)
            {
                string contentMessage = string.Empty;

                if (httpResponseMessage.Content.Headers.ContentType.MediaType.Equals("application/json"))
                {
                    string responseMessage = httpResponseMessage.Content.ReadAsStringAsync().Result;
                    if (!string.IsNullOrEmpty(responseMessage))
                    {
                        dynamic responseObject = JObject.Parse(responseMessage);

                        contentMessage = HasLowerCaseMessageProperty(responseObject) ? responseObject.message : contentMessage;
                        contentMessage = HasMessageProperty(responseObject) ? responseObject.Message : contentMessage;
                    }
                }

                string exceptionMessage = $"Response status code does not indicate success: {httpResponseMessage.StatusCode:D} ({httpResponseMessage.ReasonPhrase}).";
                exceptionMessage = string.IsNullOrWhiteSpace(contentMessage) ? exceptionMessage : $"{exceptionMessage}{Environment.NewLine}{contentMessage}";
                throw new HttpRequestException(exceptionMessage);
            }
        }
    }
}
