﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using MSI.VMS;
    using System;
    using System.Reflection;
    using System.Text;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing User Information to details string representation converter.
    /// </summary>
    internal class UserInformationToDetailsStringConverter : IValueConverter
    {
        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is UserInformation)
            {
                StringBuilder result = new StringBuilder();
                PropertyInfo[] properties = typeof(UserInformation).GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    var propertyValue = property.GetValue(value);
                    if (!property.Name.StartsWith("_"))
                    {
                        result.Append($"{property.Name}: {propertyValue}{Environment.NewLine}");
                    }
                }

                return result.ToString();
            }

            return string.Empty;
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
