﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using System;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing device status (on-line/off-line) to boolean converter.
    /// </summary>
    internal class OnlineOfflineToBooleanConverter : IValueConverter
    {
        private const string Offline = "offline";
        private const string Online = "online";

        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            switch (value.ToString().ToLower())
            {
                case Online:
                    return true;

                case Offline:
                    return false;
            }
            return false;
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is bool)
            {
                if ((bool)value)
                    return Online;
                else
                    return Offline;
            }
            return Offline;
        }
    }
}
