﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using MSI.VideoSamples.VideoPlayback.Helpers;
    using System;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing Logging in status to Login status representation converter.
    /// </summary>
    internal class LoggingInStatusToLoginStatusConverter : IValueConverter
    {
        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is LoggingInStatus loggingInStatus)
            {
                if (!loggingInStatus.IsUserLoggedIn)
                {
                    return loggingInStatus.IsLoggingInInProgress ? "Logging in..." : "User not logged in";
                }
                else
                {
                    return "User logged in";
                }
            }
            return "User not logged in";
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
