﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using System;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing Logging in progress status to Visibility representation converter.
    /// </summary>
    internal class LoggingInProgressToVisibilityConverter : IValueConverter
    {
        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is bool boolValue)
            {
                return boolValue ? "Visible" : "Hidden";
            }
            return "Hidden";
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
