﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using MSI.VMS;
    using System;
    using System.Reflection;
    using System.Text;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing Device to details string representation converter.
    /// </summary>
    internal class EventToDetailsStringConverter : IValueConverter
    {
        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is Event)
            {
                StringBuilder result = new StringBuilder();
                Event acsEvent = value as Event;
                result.Append($"Camera Name: {acsEvent.Payload.CameraName}{Environment.NewLine}");
                result.Append($"Event Name: {acsEvent.Payload.EventName}{Environment.NewLine}");
                result.Append($"Event Time: {acsEvent.Payload.EventStartTime}");
                return result.ToString();
            }

            return string.Empty;
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
