﻿namespace MSI.VideoSamples.VideoPlayback.Converters
{
    using MSI.VMS;
    using System;
    using System.Reflection;
    using System.Text;
    using System.Windows.Data;

    /// <summary>
    /// Class implementing Device to details string representation converter.
    /// </summary>
    internal class DeviceToDetailsStringConverter : IValueConverter
    {
        /// <inheritdoc/>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value is Device)
            {
                StringBuilder result = new StringBuilder();
                PropertyInfo[] properties = typeof(Device).GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    var propertyValue = property.GetValue(value);
                    if (!property.Name.StartsWith("_") && !property.Name.Equals("Geolocation"))
                    {
                        result.Append($"{property.Name}: {propertyValue}{Environment.NewLine}");
                    }
                    else if(property.Name.Equals("Geolocation"))
                    {
                        var geolocation = propertyValue as DeviceGeolocation;
                        if (geolocation != null)
                        {
                            result.Append($"{property.Name}: (Latitude: {geolocation.Latitude:0.0000000}, Longitude: {geolocation.Longitude:0.0000000}){Environment.NewLine}");
                        }
                        else
                        {
                            result.Append($"{property.Name} not available{Environment.NewLine}");
                        }
                    }
                }

                return result.ToString();
            }

            return string.Empty;
        }

        /// <inheritdoc/>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
