﻿using MSI.VideoSamples.VideoPlayback.Helpers;
using MSI.VideoSamples.VideoPlayback.Models.Events;
using MSI.VMS;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.Net.Http;
using System.Web.Http;

namespace MSI.VideoSamples.VideoPlayback.Controllers
{
    /// <summary>
    /// Controller for sharing alarm endpoint - only post request is enabled POST /alarm.
    /// Example: http://localhost:9000/alarm
    /// </summary>
    public class AlarmController : ApiController
    {
        [HttpPost]
        public void Post(HttpRequestMessage request)
        {
            var content = request.Content.ReadAsStringAsync().Result;
            JObject json = JObject.Parse(content);
            Event deserializedEvent = JsonConvert.DeserializeObject<Event>(json.ToString());
            if (MessageRequestValidator.ValidateMessageRequest(request, "authentication token"))
            {
                GlobalEventsCollection.Add(deserializedEvent);
            }
        }
    }
}
