﻿using System;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using Microsoft.Owin.Hosting;
using MSI.VideoSamples.VideoPlayback.Helpers;

namespace MSI.VideoSamples.VideoPlayback
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        /// <inheritdoc/>
        protected override void OnStartup(StartupEventArgs e)
        {
            this.RegisterGlobalExceptionHandling();
            WebApp.Start<WebAppStartupp>("http://*:9000/");

            base.OnStartup(e);
        }

        /// <summary>
        /// Registers standard unhandled exceptions handlers.
        /// </summary>
        private void RegisterGlobalExceptionHandling()
        {
            AppDomain.CurrentDomain.UnhandledException +=
                (sender, args) => CurrentDomainOnUnhandledException(args);

            Application.Current.DispatcherUnhandledException +=
                (sender, args) => CurrentOnDispatcherUnhandledException(args);

            TaskScheduler.UnobservedTaskException +=
                (sender, args) => TaskSchedulerOnUnobservedTaskException(args);
        }

        /// <summary>
        /// Handles TaskScheduler.UnobservedTaskException.
        /// </summary>
        /// <param name="args">Event arguments.</param>
        private static void TaskSchedulerOnUnobservedTaskException(UnobservedTaskExceptionEventArgs args)
        {
            ShowErrorMessage(args.Exception.InnerException);
            args.SetObserved();
        }

        /// <summary>
        /// Handles Current.DispatcherUnhandledException.
        /// </summary>
        /// <param name="args">Event arguments.</param>
        private static void CurrentOnDispatcherUnhandledException(DispatcherUnhandledExceptionEventArgs args)
        {
            ShowErrorMessage(args.Exception);
            args.Handled = true;
        }

        /// <summary>
        /// Handles CurrentDomain.UnhandledException.
        /// </summary>
        /// <param name="args">Event arguments.</param>
        private static void CurrentDomainOnUnhandledException(UnhandledExceptionEventArgs args)
        {
            var exception = args.ExceptionObject as Exception;
            ShowErrorMessage(exception);
        }

        /// <summary>
        /// Shows error message in the message box.
        /// </summary>
        /// <param name="exception"></param>
        private static void ShowErrorMessage(Exception exception)
        {
            MessageBox.Show(exception.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Error);
        }
    }
}
